	.include	'eq.s'
	.include	'externs.s'

	.bss
startbss::
;the address of olist must be on a 16 byte boundary
;each bit mapped object is 2 phrases (16 bytes)
;object is built in olist_ram, then copied into olist
olist::		ds.l	(4*GAME_OBJS)			;4 longs for each bit mapped object
			ds.l	2					;2 longs for a stop object
olist_ram::	ds.l	(4*GAME_OBJS)			;4 longs for each bit mapped object
			ds.l	2					;2 longs for a stop object
olist_bak::	ds.l	(4*GAME_OBJS)			;4 longs for each bit mapped object
			ds.l	2					;2 longs for a stop object

;------------------ (52 game objs) ------


objram::								;objects that get loaded into ram each time they change
player00::	ds.b	3168					;48 x 33 x 2 for ship
player01::	ds.b	3168
player02::	ds.b	3168
player03::	ds.b	3168
player04::	ds.b	3168
;3 line pad
pwrupdata::	ds.b	240					;16 x 15
cutrdata::	ds.b	3072					;64 x 24 x 2 for cutter ship
specdata::	ds.b	4480					;biggest is bolt 16 x 140 total
bombdata::	ds.b	208					;all 3 bombs are 16 x 13

shield00::	ds.b	6784					;shield	64 x 53 x 2
shield01::	ds.b	6784
shield02::	ds.b	6784
shield03::	ds.b	6784
shield04::	ds.b	6784
station0::	ds.b	39936				;192 x 104
statflg0::	ds.b	5376					;48 x 56
statflg1::	ds.b	5376					;48 x 56
statflg2::	ds.b	5376					;48 x 56
statflg3::	ds.b	5376					;48 x 56
statflg4::	ds.b	5376					;48 x 56
statflg5::	ds.b	5376					;48 x 56
statflg6::	ds.b	5376					;48 x 56
;3 line pad
msgdata::		ds.b	3456					;continue 192x18, game over 192x18, paused 64x18

ramobjs::								;objects that are always in ram
bulletl0::	ds.b	40					;8 x 5
bulletl1::	ds.b	56					;8 x 7
bulletl2::	ds.b	144					;16 x 9
bulletl3::	ds.b	176					;16 x 11
bulletl4::	ds.b	176					;use bulletl3 and bulletl4 as level 4 bullet
bulletl5::	ds.b	176					;use bullets l3,4,5 as level 5 bullet

exp_a0::		ds.w	(16*12)				;384
exp_a1::		ds.w	(16*14)				;448
exp_a2::		ds.w	(16*16)				;512
exp_a3::		ds.w	(16*16)				;448
									;1792
exp_b0::		ds.w	(32*16)				;1024
exp_b1::		ds.w	(32*17)				;1088
exp_b2::		ds.w	(32*21)				;1344
exp_b3::		ds.w	(32*20)				;1280
exp_b4::		ds.w	(32*22)				;1408
exp_b5::		ds.w	(32*24)				;1536
exp_b6::		ds.w	(32*22)				;1408
exp_b7::		ds.w	(32*23)				;1472
;3 line pad
									;10560
exp_c0::		ds.w	(48*27)				;2592
exp_c1::		ds.w	(48*29)				;2784
exp_c2::		ds.w	(48*32)				;3072
exp_c3::		ds.w	(48*36)				;3456
exp_c4::		ds.w	(48*38)				;3648
exp_c5::		ds.w	(48*40)				;3840
exp_c6::		ds.w	(48*39)				;3744
exp_c7::		ds.w	(48*40)				;3840
;7 line pad
									;26976
exp_d0::		ds.w	(80*44)				;7040
exp_d1::		ds.w	(80*46)				;7360
exp_d2::		ds.w	(80*49)				;7840
exp_d3::		ds.w	(80*58)				;9280
exp_d4::		ds.w	(80*61)				;9760
exp_d5::		ds.w	(80*62)				;9920
exp_d6::		ds.w	(80*64)				;10240
exp_d7::		ds.w	(80*64)				;10240
									;71680


;ram used for the different game modes
mode_ram::	ds.b	1808000
end_mode::


;GAME MODE
iconbar		==	mode_ram				;  1200		80 x 15
scorebar		==	iconbar+(80*15)		;   960		80 x 12

tile00		==	scorebar+(80*12)		; 36864		64 x 288
tile01		==	tile00+(64*288*2)		; 36864		64 x 288
tile02		==	tile01+(64*288*2)		; 36864		64 x 288
tile03		==	tile02+(64*288*2)		; 36864		64 x 288
tile04		==	tile03+(64*288*2)		; 36864		64 x 288
tile05		==	tile04+(64*288*2)		; 36864		64 x 288
tile06		==	tile05+(64*288*2)		; 36864		64 x 288
tile07		==	tile06+(64*288*2)		; 36864		64 x 288
tile08		==	tile07+(64*288*2)		; 36864		64 x 288
tile09		==	tile08+(64*288*2)		; 36864		64 x 288
tile10		==	tile09+(64*288*2)		; 36864		64 x 288
tile11		==	tile10+(64*288*2)		; 36864		64 x 288
tile12		==	tile11+(64*288*2)		; 36864		64 x 288
tile13		==	tile12+(64*288*2)		; 36864		64 x 288
tile14		==	tile13+(64*288*2)		; 36864		64 x 288
tile15		==	tile14+(64*288*2)		; 36864		64 x 288
									;589824		591984
												
screen		==	tile15+(64*288*2)		;294912		512 x 288 x 2
screenpad		==	screen+(512*288*2)		; 45056		128 bytes per tile scrolled * 352 tiles
									;339968		931952
lev_data		==	screenpad+45056		;876048
									;			1808000

;SELECT SCREEN MODE
;iconbar		==	mode_ram				;  1200		80 x 15
;scorebar		==	iconbar+(80*15)		;   960		80 x 12
sel_data		==	scorebar+(80*12)
cursdta		==	sel_data				;   160		8 x 10
bgplanet		==	cursdta+(8*10*2)		;  6144		64 x 48
plan00		==	bgplanet+(64*48*2)		;  3072		48 x 32 x 25 frames
plan01		==	plan00+(48*32*2)		;  3072
plan02		==	plan01+(48*32*2)		;  3072
plan03		==	plan02+(48*32*2)		;  3072
plan04		==	plan03+(48*32*2)		;  3072
plan05		==	plan04+(48*32*2)		;  3072
plan06		==	plan05+(48*32*2)		;  3072
plan07		==	plan06+(48*32*2)		;  3072
plan08		==	plan07+(48*32*2)		;  3072
plan09		==	plan08+(48*32*2)		;  3072
plan10		==	plan09+(48*32*2)		;  3072
plan11		==	plan10+(48*32*2)		;  3072
plan12		==	plan11+(48*32*2)		;  3072
plan13		==	plan12+(48*32*2)		;  3072
plan14		==	plan13+(48*32*2)		;  3072
plan15		==	plan14+(48*32*2)		;  3072
plan16		==	plan15+(48*32*2)		;  3072
plan17		==	plan16+(48*32*2)		;  3072
plan18		==	plan17+(48*32*2)		;  3072
plan19		==	plan18+(48*32*2)		;  3072
plan20		==	plan19+(48*32*2)		;  3072
plan21		==	plan20+(48*32*2)		;  3072
plan22		==	plan21+(48*32*2)		;  3072
plan23		==	plan22+(48*32*2)		;  3072
plan24		==	plan23+(48*32*2)		;  3072
dash			==	plan24+(48*32*2)		; 23296		448 x 52
dashplnt		==	dash+(448*52)			;  2560		48 x 32
dashwdta		==	dashplnt+(48*32)		;  4864		64 x 38
selback		==	dashwdta+(64*38*2)		;258048		448 x 288 (7 tiles)

;INTRO SCREEN
;iconbar		==	mode_ram				;  1200		80 x 15
;scorebar		==	iconbar+(80*15)		;   960		80 x 12
;other stuff is in specdata

;TITLE SCREEN MODE
titlescr		==	mode_ram				;258048			448 x 288
cglogo		==	titlescr+(448*288*2)	; 43008			192 x 112
crlogo		==	cglogo+(192*112*2)		; 13824			96 x 72

tship00		==	lev_data				;117760			320 x 184
tship01		==	tship00+(320*184*2)		;102400			256 x 200


;CONGRATS SCREEN MODE
;iconbar		==	mode_ram				;  1200		80 x 15
;scorebar		==	iconbar+(80*11)		;   960		80 x 12
congscrn		==	scorebar+(80*12*2)		;			448 x 288

cngline0		==	lev_data				;  5760		192 x 15
cngline4		==	cngline0+(192*15*2)		;  5760		192 x 15
;2 line pad
cngline1		==	cngline4+(192*15*2)		;  4800		160 x 15
cngline3		==	cngline1+(160*15*2)		;  4800		160 x 15
;2 line pad
cngline2		==	cngline3+(160*15*2)		;  6720		224 x 15
cngline5		==	cngline2+(224*15*2)		;  6720		224 x 15
;2 line pad
cngline6		==	cngline5+(224*15*2)		;  1920		 80 x 12
;4 line pad
cngline7		==	cngline6+(80*12*2)		;  9600		320 x 15
;1 line pad
cngline8		==	cngline7+(320*15*2)		;  7680		256 x 15
;1 line pad

;ENEMIES for desert/swamp level
spore0	==	lev_data			;  6144				64 x 48
spore1	==	spore0+6144		;  6144
spore2	==	spore1+6144		;  6144
spore3	==	spore2+6144		;  6144
spore4	==	spore3+6144		;  6144
spore5	==	spore4+6144		;  6144
spore6	==	spore5+6144		;  6144
							; 43008		 43008
fern0	==	spore6+6144		;  1792
fern1	==	fern0+1792		;  1792
fern2	==	fern1+1792		;  1792
fern3	==	fern2+1792		;  1792
fern4	==	fern3+1792		;  1792
fern5	==	fern4+1792		;  1792
fern6	==	fern5+1792		;  1792
fern7	==	fern6+1792		;  1792
							; 14336		 57344
pillbug0	==	fern7+1792		;   512				16 x 16
pillbug1	==	pillbug0+512		;   512
pillbug2	==	pillbug1+512		;   512
pillbug3	==	pillbug2+512		;   512
pillbug4	==	pillbug3+512		;   512
pillbug5	==	pillbug4+512		;   512
pillbug6	==	pillbug5+512		;   512
pillbug7	==	pillbug6+512		;   512
pillexp0	==	pillbug7+512		;  1536				32 x 24
pillexp1	==	pillexp0+1536		;  1536
pillexp2	==	pillexp1+1536		;  1536
							;  8704		 66048
seymor0	==	pillexp2+1536		;  4992				48 x 52
seymor1	==	seymor0+4992		;  4992
seymor2	==	seymor1+4992		;  4992
seymor3	==	seymor2+4992		;  4992
seymor4	==	seymor3+4992		;  4992
seymor5	==	seymor4+4992		;  4992
seymor6	==	seymor5+4992		;  4992
seymexp0	==	seymor6+4992		;  6144				48 x 64
seymexp1	==	seymexp0+6144		;  6144
seymexp2	==	seymexp1+6144		;  6144
seymexp3	==	seymexp2+6144		;  6144
;4 line pad
							; 59520		125568
bskull0	==	seymexp3+6144		;  1856				32 x 29
bskull1	==	bskull0+1856		;  1856
bskull2	==	bskull1+1856		;  1856
bskull3	==	bskull2+1856		;  1856
bskull4	==	bskull3+1856		;  1856
bskull5	==	bskull4+1856		;  1856
bskull6	==	bskull5+1856		;  1856
bskull7	==	bskull6+1856		;  1856
							; 14848		140416
flwr00	==	bskull7+1856		;   512
flwr01	==	flwr00+512		;   512
flwr02	==	flwr01+512		;   512
flwr03	==	flwr02+512		;   512
flwr04	==	flwr03+512		;   512
flwr05	==	flwr04+512		;   512
flwr06	==	flwr05+512		;   512
							;  3584		144000
gund00	==	flwr06+512		;  1408
gund01	==	gund00+1408		;  1408
gund02	==	gund01+1408		;  1408
gund03	==	gund02+1408		;  1408
gund04	==	gund03+1408		;  1408
gund05	==	gund04+1408		;  1408
gund06	==	gund05+1408		;  1408
;6 line pad
							;  9856		153856
kilrun00	==	gund06+1408		;  4416				48 x 46
kilrun01	==	kilrun00+4416		;  4416				48 x 46
kilrun02	==	kilrun01+4416		;  4416				48 x 46
kilrun03	==	kilrun02+4416		;  4416				48 x 46
kilrun04	==	kilrun03+4416		;  4416				48 x 46
kilrun05	==	kilrun04+4416		;  4416				48 x 46
kilrun06	==	kilrun05+4416		;  4416				48 x 46
kilrun07	==	kilrun06+4416		;  4512				48 x 47
kilrun08	==	kilrun07+4512		;  4512				48 x 47
							; 35520		189376
sadmsk00	==	kilrun08+4512		;  4608				48 x 48
sadmsk01	==	sadmsk00+4608		;  4512				48 x 47
sadmsk02	==	sadmsk01+4512		;  4608				48 x 48
sadmsk03	==	sadmsk02+4608		;  4512				48 x 47
sadmsk04	==	sadmsk03+4512		;  4608				48 x 48
sadmsk05	==	sadmsk04+4608		;  4608				48 x 48
sadmsk06	==	sadmsk05+4608		;  4608				48 x 48
sadmsk07	==	sadmsk06+4608		;  4608				48 x 48
sadmsk08	==	sadmsk07+4608		;  4512				48 x 47
sadmsk09	==	sadmsk08+4512		;  3168				48 x 33
;2 line pad
							; 44352		233728
ffly00	==	sadmsk09+3168		;  1344				32 x 21
ffly01	==	ffly00+1344		;  1344
ffly02	==	ffly01+1344		;  1344
ffly03	==	ffly02+1344		;  1344
ffly04	==	ffly03+1344		;  1344
ffly05	==	ffly04+1344		;  1344
;2 line pad
							;  8064		241792
buggy0	==	ffly05+1344		;  2592				48 x 27
buggy1	==	buggy0+2592		;  2592
buggy2	==	buggy1+2592		;  2592
buggy3	==	buggy2+2592		;  2592
buggy4	==	buggy3+2592		;  2592
buggy5	==	buggy4+2592		;  2592
buggy6	==	buggy5+2592		;  2592
buggy7	==	buggy6+2592		;  2592
buggy8	==	buggy7+2592		;  2592
buggy9	==	buggy8+2592		;  2592
buggy10	==	buggy9+2592		;  2592
buggy11	==	buggy10+2592		;  2592
;4 line pad
							; 31104		272896
moss0	==	buggy11+2592		; 24576				128 x 96
mossrk0	==	moss0+24576		; 55296				192 x 144
stump0	==	mossrk0+55296		; 46080				160 x 144
tree0	==	stump0+46080		; 92160				160 x 288
							;218112		491008

spit0	==	tree0+92160		;   384				16 x 24, firstpix 2
spit1	==	spit0+384			;   384
spit2	==	spit1+384			;   384
fernsht0	==	spit2+384			;    32				8 x 4, firstpix 4
fernsht1	==	fernsht0+32		;    32
fernsht2	==	fernsht1+32		;    32
fernsht3	==	fernsht2+32		;    32
seyshot0	==	fernsht3+32		;    64				16 x 4, firstpix 0
seyshot1	==	seyshot0+64		;    64
bskshot	==	seyshot1+64		;    16				8 x 2, firstpix 1
gundsht0	==	bskshot+16		;    16				8 x 2, firstpix 0
gundsht1	==	gundsht0+16		;    16
gundsht2	==	gundsht1+16		;    16
kilrunsh	==	gundsht2+16		;    24				8 x 3, firstpix 2
sadmsht0	==	kilrunsh+24		;    32				8 x 4, firstpix 2
sadmsht1	==	sadmsht0+32		;    32
sadmsht2	==	sadmsht1+32		;    32
fflysht0	==	sadmsht2+32		;   128				16 x 8, firstpix 0
fflysht1	==	fflysht0+128		;   128
buggysh0	==	fflysht1+128		;    16				8 x 2, firstpix 2
buggysh1	==	buggysh0+16		;    16				8 x 2, firstpix 2
buggysh2	==	buggysh1+16		;    16				8 x 2, firstpix 2
buggysh3	==	buggysh2+16		;    16				8 x 2, firstpix 2
							;  1912		492920

;---------------------------------------------------------------------------------------
;DESERT LEVEL
trat00	==	lev_data			;  4864				64 x 38
trat01	==	trat00+4864		;  4864				64 x 38
trat02	==	trat01+4864		;  4736				64 x 37
trat03	==	trat02+4736		;  4864				64 x 38
trat04	==	trat03+4864		;  4736				64 x 37
trat05	==	trat04+4736		;  4864				64 x 38
trat06	==	trat05+4864		;  5120				64 x 40
trat07	==	trat06+5120		;  6400				64 x 50
trat08	==	trat07+6400		;  4864				64 x 38
trat09	==	trat08+4864		;  4864				64 x 38
trat10	==	trat09+4864		;  5120				64 x 40
trat11	==	trat10+5120		;  5760				64 x 45
trat12	==	trat11+5760		;  6144				64 x 48
trat13	==	trat12+6144		;  6400				64 x 50
trat14	==	trat13+6400		;  5760				64 x 45
trat15	==	trat14+5760		;  5248				64 x 41
trat16	==	trat15+5248		;  4864				64 x 38
trat17	==	trat16+4864		;  4864				64 x 38
trat18	==	trat17+4864		;  4864				64 x 38
;1 line pad
							; 99200		 99200
scorp00b	==	trat18+4864		; 37632				192 x 98
scorp01b	==	scorp00b+37632		; 37632
scorp02b	==	scorp01b+37632		; 37632
scorp03b	==	scorp02b+37632		; 37632
scorp04b	==	scorp03b+37632		; 37632
scorp05b	==	scorp04b+37632		; 37632
;4 line pad
							;225792		324992
scorp00s	==	scorp05b+37632		;  1024				32 x 16
scorp01s	==	scorp00s+1024		;  1024
scorp02s	==	scorp01s+1024		;  1024
scorp03s	==	scorp02s+1024		;  1024
scorp04s	==	scorp03s+1024		;  1024
scorp05s	==	scorp04s+1024		;  1024
							;  6144		331136
fbug00	==	scorp05s+1024		;  3648				48 x 38
fbug01	==	fbug00+3648		;  3744				48 x 39
fbug02	==	fbug01+3744		;  3840				48 x 40
fbug03	==	fbug02+3840		;  3936				48 x 41
fbug04	==	fbug03+3936		;  3840				48 x 40
fbug05	==	fbug04+3840		;  3840				48 x 40
fbug06	==	fbug05+3840		;  5280				48 x 55
fbug07	==	fbug06+5280		;  5184				48 x 54
fbug08	==	fbug07+5184		;  5280				48 x 55
fbug09	==	fbug08+5280		;  4896				48 x 51
fbug10	==	fbug09+4896		;  3744				48 x 39
fbug11	==	fbug10+3744		;  3936				48 x 41
fbug12	==	fbug11+3936		;  4320				48 x 45
fbug13	==	fbug12+4320		;  4704				48 x 49
fbug14	==	fbug13+4704		;  4608				48 x 48
fbug15	==	fbug14+4608		;  4416				48 x 46
fbug16	==	fbug15+4416		;  4128				48 x 43
fbug17	==	fbug16+4128		;  3840				48 x 40
fbug18	==	fbug17+3840		;  3744				48 x 39
;5 line pad
							; 80928		412064
vult00	==	fbug18+3744		;  5888				64 x 46		00 - 10 flying
vult01	==	vult00+5888		;  5632				64 x 44
vult02	==	vult01+5632		;  4608				64 x 36
vult03	==	vult02+4608		;  4096				64 x 32
vult04	==	vult03+4096		;  4096				64 x 32
vult05	==	vult04+4096		;  4096				64 x 32
vult06	==	vult05+4096		;  3968				64 x 31
vult07	==	vult06+3968		;  4096				64 x 32
vult08	==	vult07+4096		;  5632				64 x 44
vult09	==	vult08+5632		;  5888				64 x 46
vult10	==	vult09+5888		;  5376				64 x 42
vult11	==	vult10+5376		;  5376				64 x 42		11 - 19 attacking
vult12	==	vult11+5376		;  4992				64 x 39
vult13	==	vult12+4992		;  3968				64 x 31
vult14	==	vult13+3968		;  4096				64 x 32
vult15	==	vult14+4096		;  4096				64 x 32
vult16	==	vult15+4096		;  4096				64 x 32
vult17	==	vult16+4096		;  3968				64 x 31
vult18	==	vult17+3968		;  4224				64 x 33
vult19	==	vult18+4224		;  5632				64 x 44
vult20	==	vult19+5632		;  3200				64 x 25		20 - 31 appearing
vult21	==	vult20+3200		;  3328				64 x 26
vult22	==	vult21+3328		;  3584				64 x 28
vult23	==	vult22+3584		;  3840				64 x 30
vult24	==	vult23+3840		;  4224				64 x 33
vult25	==	vult24+4224		;  4224				64 x 33
vult26	==	vult25+4224		;  4096				64 x 32
vult27	==	vult26+4096		;  4096				64 x 32
vult28	==	vult27+4096		;  3968				64 x 31
vult29	==	vult28+3968		;  3968				64 x 31
vult30	==	vult29+3968		;  5504				64 x 43
vult31	==	vult30+5504		;  6016				64 x 47
;4 line pad
							;143872		555936
ball00	==	vult31+6016		;  6144
							;  6144		562080
geyser00	==	ball00+6144		;  1536				48 x 16
geyser01	==	geyser00+1536		;  2688				48 x 28
geyser02	==	geyser01+2688		;  4608				48 x 48
geyser03	==	geyser02+4608		;  8160				48 x 85
geyser04	==	geyser03+8160		; 11904				48 x 124
geyser05	==	geyser04+11904		; 19008				48 x 198
geyser06	==	geyser05+19008		; 23328				48 x 243
							; 71232		633312
poppy00	==	geyser06+23328		;  3648				32 x 57
;7 line pad
poppy01	==	poppy00+3648		;  1312				16 x 48
;7 line pad
poppy02	==	poppy01+1312		;  4736				32 x 74
;6 line pad
							;  9696		643008

;FOREGROUND OBJECTS
dso00	==	poppy02+4736		; 61440
dso01	==	dso00+61440		; 23040
dso02	==	dso01+23040		; 46592
dso03	==	dso02+46592		; 33792
dso04	==	dso03+33792		; 25600
							;190464		833472

tratshot	==	dso04+25600		;     8				8 x 1, firstpix 0
scorpsh0	==	tratshot+8		;   128				8 x 8 x 2, firstpix 0
scorpsh1	==	scorpsh0+128		;    56
scorpsh2	==	scorpsh1+56		;    56
scorpsh3	==	scorpsh2+56		;    56
fbugsht0	==	scorpsh3+56		;    80				16 x 5, firstpix0
fbugsht1	==	fbugsht0+80		;    80
vultshot	==	fbugsht1+80		;   288
							;   752		834224

;-------------------------------------------------------------------------------
;CAVE
bat00	==	lev_data			;  3584				64 x 28
bat01	==	bat00+3584		;  3712				64 x 29
bat02	==	bat01+3712		;  3712				64 x 29
bat03	==	bat02+3712		;  3968				64 x 31
bat04	==	bat03+3968		;  4096				64 x 32
bat05	==	bat04+4096		;  3840				64 x 30
bat06	==	bat05+3840		;  3456				64 x 27
bat07	==	bat06+3456		;  3584				64 x 28
bat08	==	bat07+3584		;  3328				64 x 26
bat09	==	bat08+3328		;  3200				64 x 25
bat10	==	bat09+3200		;  3072				64 x 24
bat11	==	bat10+3072		;  3328				64 x 26
bat12	==	bat11+3328		;  3456				64 x 27
bat13	==	bat12+3456		;  3584				64 x 28
bat14	==	bat13+3584		;  3712				64 x 29
bat15	==	bat14+3712		;  3840				64 x 30
bat16	==	bat15+3840		;  3968				64 x 31
bat17	==	bat16+3968		;  3968				64 x 31
bat18	==	bat17+3968		;  3968				64 x 31
bat19	==	bat18+3968		;  3840				64 x 30
bat20	==	bat19+3840		;  3584				64 x 28
bat21	==	bat20+3584		;  3584				64 x 28
bat22	==	bat21+3584		;  3456				64 x 27
bat23	==	bat22+3456		;  2816				64 x 22
bat24	==	bat23+2816		;  2944				64 x 23
bat25	==	bat24+2944		;  3328				64 x 26
bat26	==	bat25+3328		;  3328				64 x 26
bat27	==	bat26+3328		;  3712				64 x 29
							; 99968		 99968
spidsm00	==	bat27+3712		;  2688				48 x 28
spidsm01	==	spidsm00+2688		;  2688
spidsm02	==	spidsm01+2688		;  2688
spidsm03	==	spidsm02+2688		;  2688
spidsm04	==	spidsm03+2688		;  2688
spidsm05	==	spidsm04+2688		;  2688
							; 16128		116096
spidbg00	==	spidsm05+2688		; 12096
spidbg01	==	spidbg00+12096		; 12096
spidbg02	==	spidbg01+12096		; 12096
spidbg03	==	spidbg02+12096		; 12096
spidbg04	==	spidbg03+12096		; 12096
spidbg05	==	spidbg04+12096		; 12096
;6 line pad
							; 72576		188672
slug00	==	spidbg05+12096		;  1824
slug01	==	slug00+1824		;  1824
slug02	==	slug01+1824		;  1824
slug03	==	slug02+1824		;  1824
slug04	==	slug03+1824		;  1824
slug05	==	slug04+1824		;  1824
;6 line pad
							; 10944		199616
dino00	==	slug05+1824		; 36864
dino01	==	dino00+36864		; 36864
dino02	==	dino01+36864		; 36864
dino03	==	dino02+36864		; 36864
dino04	==	dino03+36864		; 36864
dino05	==	dino04+36864		; 36864
dino06	==	dino05+36864		; 36864
dino07	==	dino06+36864		; 36864
							;294912		494528
dinos00	==	dino07+36864		;  4096				64 x 32
dinos01	==	dinos00+4096		;  4096
dinos02	==	dinos01+4096		;  4096
dinos03	==	dinos02+4096		;  4096
dinos04	==	dinos03+4096		;  4096
dinos05	==	dinos04+4096		;  4096
dinos06	==	dinos05+4096		;  4096
dinos07	==	dinos06+4096		;  4096
							; 32768		527296
glow00	==	dinos07+4096		;  3744				48 x 39
glow01	==	glow00+3744		;  3744				48 x 39
glow02	==	glow01+3744		;  3648				48 x 38
glow03	==	glow02+3648		;  3552				48 x 37
glow04	==	glow03+3552		;  3744				48 x 39
glow05	==	glow04+3744		;  3648				48 x 38
glow06	==	glow05+3648		;  3552				48 x 37
glow07	==	glow06+3552		;  3456				48 x 36
;1 line pad
							; 29088		556384
;rocks are ordered this way so adjblack can stop after cvrock04
cvrock00	==	glow07+3456		; 40960				;160 x 128
cvrock02	==	cvrock00+40960		; 28160				;160 x 88
cvrock04	==	cvrock02+28160		;  7680				;48 x 80
cvrock01	==	cvrock04+7680		; 40960				cvrock00 vertically flipped
cvrock03	==	cvrock01+40960		; 28160				cvrock02 vertically flipped
							;145920		702304
slugshot	==	cvrock03+28160		;   264				24 x 11, firstpix 0
dinoshot	==	slugshot+264		;    72				24 x  3, firstpix 0
							;   336		702640

;---------------------------------------------------------------------------------
;AIR
spin00	==	lev_data			;  1632				48 x 17
spin01	==	spin00+1632		;  1632
spin02	==	spin01+1632		;  1632
spin03	==	spin02+1632		;  1632
spin04	==	spin03+1632		;  1632
spin05	==	spin04+1632		;  1632
spin06	==	spin05+1632		;  1632
spin07	==	spin06+1632		;  1632
							; 13056		 13056
humm00	==	spin07+1632		;  1344				32 x 21
humm01	==	humm00+1344		;  1344				32 x 21
humm02	==	humm01+1344		;  1344				32 x 21
humm03	==	humm02+1344		;  1344				32 x 21
humm04	==	humm03+1344		;  1280				32 x 20
humm05	==	humm04+1280		;  1280				32 x 20
humm06	==	humm05+1280		;  1280				32 x 20
humm07	==	humm06+1280		;  1408				32 x 22
humm08	==	humm07+1408		;  1472				32 x 23
humm09	==	humm08+1472		;  1536				32 x 24
;3 line pad
							; 13632		 26688
baby00	==	humm09+1536		; 22784
baby01	==	baby00+22784		; 22784
baby02	==	baby01+22784		; 22784
baby03	==	baby02+22784		; 22784
baby04	==	baby03+22784		; 22784
baby05	==	baby04+22784		; 22784
baby06	==	baby05+22784		; 22784
baby07	==	baby06+22784		; 22784
baby08	==	baby07+22784		; 22784
baby09	==	baby08+22784		; 22784
baby10	==	baby09+22784		; 22784
baby11	==	baby10+22784		; 22784
baby12	==	baby11+22784		; 22784
baby13	==	baby12+22784		; 22784
							;318976		345664
dragon00	==	baby13+22784		;  8960				80 x 56
dragon01	==	dragon00+8960		;  8640				80 x 54
dragon02	==	dragon01+8640		;  8480				80 x 53
dragon03	==	dragon02+8480		;  8320				80 x 52
dragon04	==	dragon03+8320		;  8320				80 x 52
dragon05	==	dragon04+8320		;  8320				80 x 52
;1 line pad
							; 51040		396704

blockb00	==	dragon05+8320		; 73728				256 x 144
blockb01	==	blockb00+73728		; 73728
blockm00	==	blockb01+73728		; 41472				192 x 108
blocks00	==	blockm00+43008		; 18432				128 x 72
blocks01	==	blocks00+18432		; 18432
							;225792		622496

hummshot	==	blocks01+18432		;   144
babyshot	==	hummshot+144		;   416
dragshot	==	babyshot+416		;   288
							;   848		623344
;----------------------------------------------------------------------------------
;CITY
tile21	==	tile00			; 36864

tile16	==	lev_data			; 36864
tile17	==	tile16+36864		; 36864
tile18	==	tile17+36864		; 36864
tile19	==	tile18+36864		; 36864
tile20	==	tile19+36864		; 36864
							;184320		184320
fishtx00	==	tile20+36864		;  4608				64 x 36
fishtx01	==	fishtx00+4608		;  4480				64 x 35
fishtx02	==	fishtx01+4480		;  4352				64 x 34
fishtx03	==	fishtx02+4352		;  4352				64 x 34
fishtx04	==	fishtx03+4352		;  4352				64 x 34
fishtx05	==	fishtx04+4352		;  4480				64 x 35
fishtx06	==	fishtx05+4480		;  4608				64 x 36
fishtx07	==	fishtx06+4608		;  4736				64 x 37
fishtx08	==	fishtx07+4736		;  5120				64 x 40
fishtx09	==	fishtx08+5120		;  4736				64 x 37
fishtx10	==	fishtx09+4736		;  4608				64 x 36
fishtx11	==	fishtx10+4608		;  4608				64 x 36
fishtx12	==	fishtx11+4608		;  4608				64 x 36
fishtx13	==	fishtx12+4608		;  5120				64 x 40
fishtx14	==	fishtx13+5120		;  5120				64 x 40
fishtx15	==	fishtx14+5120		;  5376				64 x 42
fishtx16	==	fishtx15+5376		;  5376				64 x 42
fishtx17	==	fishtx16+5376		;  5376				64 x 42
fishtx18	==	fishtx17+5376		;  5376				64 x 42
fishtx19	==	fishtx18+5376		;  5376				64 x 42
fishtx20	==	fishtx19+5376		;  5120				64 x 40
fishtx21	==	fishtx20+5120		;  4608				64 x 36
fishtx22	==	fishtx21+4608		;  4608				64 x 36
;4 line pad
							;111104		295424
snake00	==	fishtx22+4608		;  2112				96 x 11
snake01	==	snake00+(96*11*2)	;  3072				96 x 16
snake02	==	snake01+(96*16*2)	;  5760				96 x 30
;7 line pad
snake03	==	snake02+(96*30*2)	;  6720				80 x 42
snake04	==	snake03+(80*42*2)	;  7840				80 x 49
;5 line pad
snake05	==	snake04+(80*49*2)	;  6528				64 x 51
snake06	==	snake05+(64*51*2)	;  6528				64 x 51
snake07	==	snake06+(64*51*2)	;  6144				64 x 48
;2 line pad
snake08	==	snake07+(64*48*2)	;  4416				48 x 46
snake09	==	snake08+(48*46*2)	;  4128				48 x 43
snake10	==	snake09+(48*43*2)	;  4032				48 x 42
snake11	==	snake10+(48*42*2)	;  3936				48 x 41
snake12	==	snake11+(48*41*2)	;  3648				48 x 38
snake13	==	snake12+(48*38*2)	;  3456				48 x 36
snake14	==	snake13+(48*36*2)	;  3456				48 x 36
snake15	==	snake14+(48*36*2)	;  3264				48 x 34
;4 line pad
snake16	==	snake15+(48*34*2)	;  2240				32 x 35 appearing
snake17	==	snake16+(32*35*2)	;  2176				32 x 34
snake18	==	snake17+(32*34*2)	;  1984				32 x 31
snake19	==	snake18+(32*31*2)	;  1856				32 x 29
snake20	==	snake19+(32*29*2)	;  1792				32 x 28
snake21	==	snake20+(32*28*2)	;  1664				32 x 26
snake22	==	snake21+(32*26*2)	;  1600				32 x 25
							; 88352		383776
tower00	==	snake22+(32*25*2)	; 20480				64 x 160
							; 20480		404256
ming00	==	tower00+20480		; 24576
							; 24576		428832
robot00	==	ming00+24576		; 30720				160 x 96
robot01	==	robot00+30720		; 28480				160 x 89
robot02	==	robot01+28480		; 27840				160 x 87
robot03	==	robot02+27840		; 27200				160 x 85
robot04	==	robot03+27200		; 27200				160 x 85
							;141440		570272
bldg00	==	robot04+27200		; 17920				 80 x 112
bldg01	==	bldg00+(80*112*2)	; 40960				160 x 128
bldg02	==	bldg01+(160*128*2)	; 32768				128 x 128
bldg03	==	bldg02+(128*128*2)	; 19712				112 x 88
							;111360		681632
elec00	==	bldg03+(112*88*2)	;  6144				192 x 16
elec01	==	elec00+(192*16*2)	;  6144				192 x 16
elec02	==	elec01+(192*16*2)	;  6144				192 x 16
elec03	==	elec02+(192*16*2)	;  6144				192 x 16
							; 24576		706208
eyelgbl0	==	elec03+(192*16*2)	;  6656				 64 x 52
eyelgbl1	==	eyelgbl0+(64*52*2)	;  6656
eyelgbl2	==	eyelgbl1+(64*52*2)	;  6656
eyelgbl3	==	eyelgbl2+(64*52*2)	;  6656
eyelgbl4	==	eyelgbl3+(64*52*2)	;  6656
eyelgbl5	==	eyelgbl4+(64*52*2)	;  6656
eyelgbl6	==	eyelgbl5+(64*52*2)	;  6656
eyelgbl7	==	eyelgbl6+(64*52*2)	;  6656
							; 53248		759456
eyelggr0	==	eyelgbl7+(64*52*2)	;  6656				 64 x 52
eyelggr1	==	eyelggr0+(64*52*2)	;  6656
eyelggr2	==	eyelggr1+(64*52*2)	;  6656
eyelggr3	==	eyelggr2+(64*52*2)	;  6656
eyelggr4	==	eyelggr3+(64*52*2)	;  6656
eyelggr5	==	eyelggr4+(64*52*2)	;  6656
eyelggr6	==	eyelggr5+(64*52*2)	;  6656
eyelggr7	==	eyelggr6+(64*52*2)	;  6656
							; 53248		812704
eyesmbl0	==	eyelggr7+(64*52*2)	;  3744				 48 x 39
eyesmbl1	==	eyesmbl0+(48*39*2)	;  3744
eyesmbl2	==	eyesmbl1+(48*39*2)	;  3744
eyesmbl3	==	eyesmbl2+(48*39*2)	;  3744
eyesmbl4	==	eyesmbl3+(48*39*2)	;  3744
eyesmbl5	==	eyesmbl4+(48*39*2)	;  3744
eyesmbl6	==	eyesmbl5+(48*39*2)	;  3744
eyesmbl7	==	eyesmbl6+(48*39*2)	;  3744
							; 29952		842656
eyesmgr0	==	eyesmbl7+(48*39*2)	;  3744				 48 x 39
eyesmgr1	==	eyesmgr0+(48*39*2)	;  3744
eyesmgr2	==	eyesmgr1+(48*39*2)	;  3744
eyesmgr3	==	eyesmgr2+(48*39*2)	;  3744
eyesmgr4	==	eyesmgr3+(48*39*2)	;  3744
eyesmgr5	==	eyesmgr4+(48*39*2)	;  3744
eyesmgr6	==	eyesmgr5+(48*39*2)	;  3744
eyesmgr7	==	eyesmgr6+(48*39*2)	;  3744
							; 29952		862368

fishtxsh	==	eyesmgr7+(48*39*2)	;     8
							;     8		872608


;------------------------------------------------------------------------
;ENEMIES for space levels
bigrok00	==	lev_data			;  4512
bigrok01	==	bigrok00+4512		;  4512
bigrok02	==	bigrok01+4512		;  4512
bigrok03	==	bigrok02+4512		;  4512
bigrok04	==	bigrok03+4512		;  4512
bigrok05	==	bigrok04+4512		;  4512
bigrok06	==	bigrok05+4512		;  4512
bigrok07	==	bigrok06+4512		;  4512
bigrok08	==	bigrok07+4512		;  4512
bigrok09	==	bigrok08+4512		;  4512
bigrok10	==	bigrok09+4512		;  4512
bigrok11	==	bigrok10+4512		;  4512
bigrok12	==	bigrok11+4512		;  4512
bigrok13	==	bigrok12+4512		;  4512
bigrok14	==	bigrok13+4512		;  4512
bigrok15	==	bigrok14+4512		;  4512
							; 72192		 72192
medrok00	==	bigrok15+4512		;  1472				32 x 23
medrok01	==	medrok00+1472		;  1472
medrok02	==	medrok01+1472		;  1472
medrok03	==	medrok02+1472		;  1472
medrok04	==	medrok03+1472		;  1472
medrok05	==	medrok04+1472		;  1472
medrok06	==	medrok05+1472		;  1472
medrok07	==	medrok06+1472		;  1472
medrok08	==	medrok07+1472		;  1472
medrok09	==	medrok08+1472		;  1472
medrok10	==	medrok09+1472		;  1472
medrok11	==	medrok10+1472		;  1472
medrok12	==	medrok11+1472		;  1472
medrok13	==	medrok12+1472		;  1472
medrok14	==	medrok13+1472		;  1472
medrok15	==	medrok14+1472		;  1472
							; 23552		 95744
smlrok00	==	medrok15+1472		;   352
smlrok01	==	smlrok00+352		;   352
smlrok02	==	smlrok01+352		;   352
smlrok03	==	smlrok02+352		;   352
smlrok04	==	smlrok03+352		;   352
smlrok05	==	smlrok04+352		;   352
smlrok06	==	smlrok05+352		;   352
smlrok07	==	smlrok06+352		;   352
smlrok08	==	smlrok07+352		;   352
smlrok09	==	smlrok08+352		;   352
smlrok10	==	smlrok09+352		;   352
smlrok11	==	smlrok10+352		;   352
smlrok12	==	smlrok11+352		;   352
smlrok13	==	smlrok12+352		;   352
smlrok14	==	smlrok13+352		;   352
smlrok15	==	smlrok14+352		;   352
							;  5632		101376
mdcrsa00	==	smlrok15+352		;  1472				32 x 23
mdcrsa01	==	mdcrsa00+1472		;  1472
mdcrsa02	==	mdcrsa01+1472		;  1472
mdcrsa03	==	mdcrsa02+1472		;  1472
mdcrsa04	==	mdcrsa03+1472		;  1472
mdcrsa05	==	mdcrsa04+1472		;  1472
mdcrsa06	==	mdcrsa05+1472		;  1472
mdcrsa07	==	mdcrsa06+1472		;  1472
mdcrsa08	==	mdcrsa07+1472		;  1472
mdcrsa09	==	mdcrsa08+1472		;  1472
mdcrsa10	==	mdcrsa09+1472		;  1472
mdcrsa11	==	mdcrsa10+1472		;  1472
mdcrsa12	==	mdcrsa11+1472		;  1472
mdcrsa13	==	mdcrsa12+1472		;  1472
mdcrsa14	==	mdcrsa13+1472		;  1472
mdcrsa15	==	mdcrsa14+1472		;  1472
							; 23552		124928
mdcrsb00	==	mdcrsa15+1472		;  1472				32 x 23
mdcrsb01	==	mdcrsb00+1472		;  1472
mdcrsb02	==	mdcrsb01+1472		;  1472
mdcrsb03	==	mdcrsb02+1472		;  1472
mdcrsb04	==	mdcrsb03+1472		;  1472
mdcrsb05	==	mdcrsb04+1472		;  1472
mdcrsb06	==	mdcrsb05+1472		;  1472
mdcrsb07	==	mdcrsb06+1472		;  1472
mdcrsb08	==	mdcrsb07+1472		;  1472
mdcrsb09	==	mdcrsb08+1472		;  1472
mdcrsb10	==	mdcrsb09+1472		;  1472
mdcrsb11	==	mdcrsb10+1472		;  1472
mdcrsb12	==	mdcrsb11+1472		;  1472
mdcrsb13	==	mdcrsb12+1472		;  1472
mdcrsb14	==	mdcrsb13+1472		;  1472
mdcrsb15	==	mdcrsb14+1472		;  1472
							; 23552		148480
bigcrs00	==	mdcrsb15+1472		;  8192
bigcrs01	==	bigcrs00+8192		;  8192
bigcrs02	==	bigcrs01+8192		;  8192
bigcrs03	==	bigcrs02+8192		;  8192
bigcrs04	==	bigcrs03+8192		;  8192
bigcrs05	==	bigcrs04+8192		;  8192
bigcrs06	==	bigcrs05+8192		;  8192
bigcrs07	==	bigcrs06+8192		;  8192
							; 65536		214016
bigstar0	==	bigcrs07+8192		;  8064					64 x 63
bigstar1	==	bigstar0+8064		;  8064
bigstar2	==	bigstar1+8064		;  8064
bigstar3	==	bigstar2+8064		;  8064
;4 line pad
							; 32256		246272
medstar0	==	bigstar3+8064		;  1984					32 x 31
medstar1	==	medstar0+1984		;  1984
medstar2	==	medstar1+1984		;  1984
medstar3	==	medstar2+1984		;  1984
;4 line pad
							;  7936		254208
prockb00	==	medstar3+1984		;  6400					64 x 50
prockb01	==	prockb00+6400		;  6400
prockb02	==	prockb01+6400		;  6400
prockb03	==	prockb02+6400		;  6400
prockb04	==	prockb03+6400		;  6400
prockb05	==	prockb04+6400		;  6400
prockb06	==	prockb05+6400		;  6400
prockb07	==	prockb06+6400		;  6400
prockb08	==	prockb07+6400		;  6400
prockb09	==	prockb08+6400		;  6400
prockb10	==	prockb09+6400		;  6400
prockb11	==	prockb10+6400		;  6400
prockb12	==	prockb11+6400		;  6400
prockb13	==	prockb12+6400		;  6400
;4 line pad
							; 89600		343808
prockm00	==	prockb13+6400		;  1728					32 x 27
prockm01	==	prockm00+1728		;  1728					32 x 27
prockm02	==	prockm01+1728		;  1728					32 x 27
prockm03	==	prockm02+1728		;  1600					32 x 25
prockm04	==	prockm03+1600		;  1472					32 x 23
prockm05	==	prockm04+1472		;  1408					32 x 22
prockm06	==	prockm05+1408		;  1600					32 x 25
prockm07	==	prockm06+1600		;  1728					32 x 27
prockm08	==	prockm07+1728		;  1792					32 x 28
prockm09	==	prockm08+1792		;  1728					32 x 27
prockm10	==	prockm09+1728		;  1600					32 x 25
prockm11	==	prockm10+1600		;  1536					32 x 24
prockm12	==	prockm11+1536		;  1664					32 x 26
prockm13	==	prockm12+1664		;  1728					32 x 27
							; 23040		366848
procks00	==	prockm13+1728		;   416					16 x 13
procks01	==	procks00+416		;   416
procks02	==	procks01+416		;   416
procks03	==	procks02+416		;   416
procks04	==	procks03+416		;   416
procks05	==	procks04+416		;   416
procks06	==	procks05+416		;   416
procks07	==	procks06+416		;   416
procks08	==	procks07+416		;   416
procks09	==	procks08+416		;   416
procks10	==	procks09+416		;   416
procks11	==	procks10+416		;   416
procks12	==	procks11+416		;   416
procks13	==	procks12+416		;   416
;2 line pad
							;  5824		372672
burplb00	==	procks13+416		;  5120					64 x 40
burplb01	==	burplb00+5120		;  5120					64 x 40
burplb02	==	burplb01+5120		;  5120					64 x 40
burplb03	==	burplb02+5120		;  5120					64 x 40
burplb04	==	burplb03+5120		;  4736					64 x 37
burplb05	==	burplb04+4736		;  4480					64 x 35
burplb06	==	burplb05+4480		;  4352					64 x 34
burplb07	==	burplb06+4352		;  4352					64 x 34
burplb08	==	burplb07+4352		;  4352					64 x 34
burplb09	==	burplb08+4352		;  4608					64 x 36
burplb10	==	burplb09+4608		;  4736					64 x 37
burplb11	==	burplb10+4736		;  4608					64 x 36
burplb12	==	burplb11+4608		;  4736					64 x 37
burplb13	==	burplb12+4736		;  4864					64 x 38
burplb14	==	burplb13+4864		;  5120					64 x 40
burplb15	==	burplb14+5120		;  5120					64 x 40
							; 76544		449216
burpls00	==	burplb15+5120		;  1280					32 x 20
burpls01	==	burpls00+1280		;  1280					32 x 20
burpls02	==	burpls01+1280		;  1280					32 x 20
burpls03	==	burpls02+1280		;  1280					32 x 20
burpls04	==	burpls03+1280		;  1216					32 x 19
burpls05	==	burpls04+1216		;  1152					32 x 18
burpls06	==	burpls05+1152		;  1088					32 x 17
burpls07	==	burpls06+1088		;  1088					32 x 17
burpls08	==	burpls07+1088		;  1088					32 x 17
burpls09	==	burpls08+1088		;  1152					32 x 18
burpls10	==	burpls09+1152		;  1216					32 x 19
burpls11	==	burpls10+1216		;  1152					32 x 18
burpls12	==	burpls11+1152		;  1216					32 x 19
burpls13	==	burpls12+1216		;  1216					32 x 19
burpls14	==	burpls13+1216		;  1280					32 x 20
burpls15	==	burpls14+1280		;  1280					32 x 20
							; 19264		468480
bubblb00	==	burpls15+1280		;  4096					64 x 32
bubblb01	==	bubblb00+4096		;  4096					64 x 32
bubblb02	==	bubblb01+4096		;  4224					64 x 33
bubblb03	==	bubblb02+4224		;  4224					64 x 33
bubblb04	==	bubblb03+4224		;  4096					64 x 32
bubblb05	==	bubblb04+4096		;  4480					64 x 35
bubblb06	==	bubblb05+4480		;  4864					64 x 38
bubblb07	==	bubblb06+4864		;  4992					64 x 39
bubblb08	==	bubblb07+4992		;  4992					64 x 39
bubblb09	==	bubblb08+4992		;  4992					64 x 39
bubblb10	==	bubblb09+4992		;  4992					64 x 39
bubblb11	==	bubblb10+4992		;  4992					64 x 39
bubblb12	==	bubblb11+4992		;  4992					64 x 39
bubblb13	==	bubblb12+4992		;  4736					64 x 37
bubblb14	==	bubblb13+4736		;  4224					64 x 33
bubblb15	==	bubblb14+4224		;  4096					64 x 32
							; 73088		541568
bubbls00	==	bubblb15+4992		;  1024					32 x 16
bubbls01	==	bubbls00+1024		;  1024					32 x 16
bubbls02	==	bubbls01+1024		;  1088					32 x 17
bubbls03	==	bubbls02+1088		;  1088					32 x 17
bubbls04	==	bubbls03+1088		;  1024					32 x 16
bubbls05	==	bubbls04+1024		;  1088					32 x 17
bubbls06	==	bubbls05+1088		;  1216					32 x 19
bubbls07	==	bubbls06+1216		;  1216					32 x 19
bubbls08	==	bubbls07+1216		;  1216					32 x 19
bubbls09	==	bubbls08+1216		;  1216					32 x 19
bubbls10	==	bubbls09+1216		;  1216					32 x 19
bubbls11	==	bubbls10+1216		;  1216					32 x 19
bubbls12	==	bubbls11+1216		;  1216					32 x 19
bubbls13	==	bubbls12+1216		;  1152					32 x 18
bubbls14	==	bubbls13+1152		;  1088					32 x 17
bubbls15	==	bubbls14+1088		;  1024					32 x 16
							; 18112		559680
pebblb00	==	bubbls15+1024		;  5376
pebblb01	==	pebblb00+5376		;  5376
pebblb02	==	pebblb01+5376		;  5376
pebblb03	==	pebblb02+5376		;  5376
pebblb04	==	pebblb03+5376		;  5376
pebblb05	==	pebblb04+5376		;  5376
pebblb06	==	pebblb05+5376		;  5376
pebblb07	==	pebblb06+5376		;  5376
pebblb08	==	pebblb07+5376		;  5376
pebblb09	==	pebblb08+5376		;  5376
pebblb10	==	pebblb09+5376		;  5376
pebblb11	==	pebblb10+5376		;  5376
pebblb12	==	pebblb11+5376		;  5376
pebblb13	==	pebblb12+5376		;  5376
pebblb14	==	pebblb13+5376		;  5376
pebblb15	==	pebblb14+5376		;  5376
							; 86016		645696
pebblm00	==	pebblb15+5376		;  2304				48 x 24
pebblm01	==	pebblm00+2304		;  2304
pebblm02	==	pebblm01+2304		;  2304
pebblm03	==	pebblm02+2304		;  2304
pebblm04	==	pebblm03+2304		;  2304
pebblm05	==	pebblm04+2304		;  2304
pebblm06	==	pebblm05+2304		;  2304
pebblm07	==	pebblm06+2304		;  2304
pebblm08	==	pebblm07+2304		;  2304
pebblm09	==	pebblm08+2304		;  2304
pebblm10	==	pebblm09+2304		;  2304
pebblm11	==	pebblm10+2304		;  2304
pebblm12	==	pebblm11+2304		;  2304
pebblm13	==	pebblm12+2304		;  2304
pebblm14	==	pebblm13+2304		;  2304
pebblm15	==	pebblm14+2304		;  2304
							; 36864		682560
pebbls00	==	pebblm15+2304		;   384
pebbls01	==	pebbls00+384		;   384
pebbls02	==	pebbls01+384		;   384
pebbls03	==	pebbls02+384		;   384
pebbls04	==	pebbls03+384		;   384
pebbls05	==	pebbls04+384		;   384
pebbls06	==	pebbls05+384		;   384
pebbls07	==	pebbls06+384		;   384
pebbls08	==	pebbls07+384		;   384
pebbls09	==	pebbls08+384		;   384
pebbls10	==	pebbls09+384		;   384
pebbls11	==	pebbls10+384		;   384
pebbls12	==	pebbls11+384		;   384
pebbls13	==	pebbls12+384		;   384
pebbls14	==	pebbls13+384		;   384
pebbls15	==	pebbls14+384		;   384
							;  6144		688704
cube00	==	pebbls15+384		;  3744
cube01	==	cube00+3744		;  3744
cube02	==	cube01+3744		;  3744
cube03	==	cube02+3744		;  3744
cube04	==	cube03+3744		;  3744
cube05	==	cube04+3744		;  3744
cube06	==	cube05+3744		;  3744
cube07	==	cube06+3744		;  3744
cube08	==	cube07+3744		;  3744
cube09	==	cube08+3744		;  3744
cube10	==	cube09+3744		;  3744
cube11	==	cube10+3744		;  3744
cube12	==	cube11+3744		;  3744
cube13	==	cube12+3744		;  3744
cube14	==	cube13+3744		;  3744
cube15	==	cube14+3744		;  3744
cube16	==	cube15+3744		;  3744
;1 line pad
							; 63648		752352
;universal object shots
cubeshot	==	cube16+3744		;   128				8 x 8, firstpix 0, 16 bit
spheresh	==	cubeshot+128		;   112				8 x 7, firstpix 0, 16 bit
							;   240		752592


;after universal shots						752592
sphere00	==	spheresh+112		;  2784				48 x 29
sphere01	==	sphere00+2784		;  2976				48 x 31
sphere02	==	sphere01+2976		;  3072				48 x 32
sphere03	==	sphere02+3072		;  3360				48 x 35
sphere04	==	sphere03+3360		;  3456				48 x 36
sphere05	==	sphere04+3456		;  3552				48 x 37
sphere06	==	sphere05+3552		;  3456				48 x 36
sphere07	==	sphere06+3456		;  2880				48 x 30
sphere08	==	sphere07+2880		;  2784				48 x 29
sphere09	==	sphere08+2784		;  2784				48 x 29
sphere10	==	sphere09+2784		;  2784				48 x 29
sphere11	==	sphere10+2784		;  2784				48 x 29
sphere12	==	sphere11+2784		;  2784				48 x 29
sphere13	==	sphere12+2784		;  2784				48 x 29
sphere14	==	sphere13+2784		;  2784				48 x 29
sphere15	==	sphere14+2784		;  2784				48 x 29
sphere16	==	sphere15+2784		;  2784				48 x 29
sphere17	==	sphere16+2784		;  2784				48 x 29
sphere18	==	sphere17+2784		;  2784				48 x 29
sphere19	==	sphere18+2784		;  2784				48 x 29
sphere20	==	sphere19+2784		;  2784				48 x 29
sphere21	==	sphere20+2784		;  2784				48 x 29
sphere22	==	sphere21+2784		;  2784				48 x 29
sphere23	==	sphere22+2784		;  2784				48 x 29
sphere24	==	sphere23+2784		;  2784				48 x 29
;1 line pad
							; 72864		825456

;after universal shots						752592
tri00	==	spheresh+112		;  2976				48 x 31
tri01	==	tri00+2976		;  2976
tri02	==	tri01+2976		;  2976
tri03	==	tri02+2976		;  2976
tri04	==	tri03+2976		;  2976
tri05	==	tri04+2976		;  2976
tri06	==	tri05+2976		;  2976
tri07	==	tri06+2976		;  2976
tri08	==	tri07+2976		;  2976
tri09	==	tri08+2976		;  2976
tri10	==	tri09+2976		;  2976
tri11	==	tri10+2976		;  2976
tri12	==	tri11+2976		;  2976
tri13	==	tri12+2976		;  2976
tri14	==	tri13+2976		;  2976
tri15	==	tri14+2976		;  2976
							; 47616		800208
tri16	==	tri15+2976		;   224				16 x 7	top piece
tri17	==	tri16+224			;   224
tri18	==	tri17+224			;   224
tri19	==	tri18+224			;   224
;4 line pad
							;   896		801104
tri20	==	tri19+224			;   704				32 x 11	top middle piece
tri21	==	tri20+704			;   704
tri22	==	tri21+704			;   704
tri23	==	tri22+704			;   704
;4 line pad
							;  2816		803920
tri24	==	tri23+704			;   832				32 x 13	bottom middle piece
tri25	==	tri24+832			;   832
tri26	==	tri25+832			;   832
tri27	==	tri26+832			;   832
;4 line pad
							;  3328		807248


;----------------------------------------------------------------------------------------
;bonus level
ring00	==	lev_data			; 21760				80 x 136
ring01	==	ring00+21760		; 47104				128x 184
ring02	==	ring01+47104		; 11264				64 x 88
ring03	==	ring02+11264		; 23040				96 x 120
ring04	==	ring03+23040		;  4096				32 x 64
ring05	==	ring04+4096		; 11264				64 x 88
							;118528

;-----------------------------------------------------------------------------------------


destop0	==	lev_data			; 31488				192 x 82
destop1	==	destop0+31488		; 31488
destop2	==	destop1+31488		; 31488
;2 line pad
							; 94464
desbot0	==	destop2+31488		;  4096					 32 x 64
desbot1	==	desbot0+4096		;  4096
desbot2	==	desbot1+4096		;  4096
							; 12288	106752
desbssh0	==	desbot2+4096		;  1344					48 x 14
desbssh1	==	desbssh0+1344		;  1344
;2 line pad
desbssh2	==	desbssh1+1344		;  1344					desbssh0 horiz flipped
desbssh3	==	desbssh2+1344		;  1344					desbssh1 horiz flipped
							;  5376	112128


airboss0	==	lev_data			; 47040			160 x 147
airboss1	==	airboss0+47040		; 47040			160 x 147 
airboss2	==	airboss1+47040		; 36160			160 x 113
airboss3	==	airboss2+36160		; 41280			160 x 129
airboss4	==	airboss3+41280		; 45760			160 x 143
airboss5	==	airboss4+45760		; 32960			160 x 103
airboss6	==	airboss5+32960		; 30400			160 x  95
airboss7	==	airboss6+30400		; 38720			160 x 121
airboss8	==	airboss7+38720		;   416			shot
							;319776


cvboss00	==	lev_data			; 51840			128 x 162	attacking, object is 160 x 162
cvboss01	==	cvboss00+51840		; 51840
cvboss02	==	cvboss01+51840		; 51840
cvboss03	==	cvboss02+51840		; 51840
cvboss04	==	cvboss03+51840		; 51840
cvboss05	==	cvboss04+51840		; 51840
cvboss06	==	cvboss05+51840		; 51840
cvboss07	==	cvboss06+51840		; 62208			160 x 162 spinning, object is 192 x 162
cvboss08	==	cvboss07+62208		; 62208
cvboss09	==	cvboss08+62208		; 62208
cvboss10	==	cvboss09+62208		; 62208
cvboss11	==	cvboss10+62208		; 62208
cvboss12	==	cvboss11+62208		; 62208
cvboss13	==	cvboss12+62208		; 62208
cvboss14	==	cvboss13+62208		; 62208
							;860544		860544
cvbssh0	==	cvboss14+62208		;  1024			;32 x 16		shot from tube
cvbssh1	==	cvbssh0+1024		;   960			;24 x 20		shot from arm
							;  1984		862528



wboss00	==	lev_data			; 41280			body 160 x 129
wboss01	==	wboss00+41280		; 41280
wboss02	==	wboss01+41280		; 41280
wboss03	==	wboss02+41280		; 41280
wboss04	==	wboss03+41280		; 41280
wboss05	==	wboss04+41280		; 41280
;6 line pad
wboss06	==	wboss05+41280		;  8480			tail 80 x 53
wboss07	==	wboss06+8480		;  8480
wboss08	==	wboss07+8480		;  8480
wboss09	==	wboss08+8480		;  8480
wboss10	==	wboss09+8480		;  8480
wboss11	==	wboss10+8480		;  8480
;2 line pad
wboss12	==	wboss11+8480		; 10720			right arm 80 x 67
wboss13	==	wboss12+10720		; 10720
wboss14	==	wboss13+10720		; 10720
wboss15	==	wboss14+10720		; 10720
;4 line pad
wboss16	==	wboss15+10720		; 22016			left arm 128 x 86
wboss17	==	wboss16+22016		; 22016
wboss18	==	wboss17+22016		; 22016
wboss19	==	wboss18+22016		; 22016
wboss20	==	wboss19+22016		; 22016
wboss21	==	wboss20+22016		; 22016
wboss22	==	wboss21+22016		; 22016
wboss23	==	wboss22+22016		; 22016
							;517568
wshot00	==	wboss23+22016		;   288			left hand, right hand shot 12 x 12
wshot01	==	wshot00+288		;   128			tail shot 8 x 8
							;   416

skribs	==	lev_data			;  7680			96 x  40
							;  7680	  7680
skneck00	==	skribs+7680		;  2880			48 x 30
skneck01	==	skneck00+(48*30*2)	;  2304			48 x 24
skneck02	==	skneck01+(48*24*2)	;  1728			48 x 18
skneck03	==	skneck02+(48*18*2)	;  2880			48 x 30
skneck04	==	skneck03+(48*30*2)	;  2880			48 x 30
							; 12672	 20352
							;
skhead00	==	skneck04+(48*30*2)	;  7040			80 x 44
skhead01	==	skhead00+(80*44*2)	;  9440			80 x 59
skhead02	==	skhead01+(80*59*2)	; 11520			80 x 72
skhead03	==	skhead02+(80*72*2)	; 10400			80 x 65
skhead04	==	skhead03+(80*65*2)	;  8640			80 x 54
skhead05	==	skhead04+(80*54*2)	;  8000			80 x 50
skhead06	==	skhead05+(80*50*2)	;  9920			80 x 62
skhead07	==	skhead06+(80*62*2)	; 12320			80 x 77
							; 77280	 97632
skarm00	==	skhead07+(80*77*2)	;  5632			128 x 22
skarm05	==	skarm00+(128*22*2)	;  5632			128 x 22
skarm01	==	skarm05+(128*22*2)	; 12800			80 x 80
skarm02	==	skarm01+(80*80*2)	; 12800			32 x 88
skarm03	==	skarm02+(32*88*2)	; 12800			64 x 80
skarm04	==	skarm03+(64*80*2)	; 12800			112 x 40
							; 62464	160096
skhrnb00	==	skarm04+(112*40*2)	;  5632			64 x 44
skhrnb01	==	skhrnb00+(64*44*2)	;  5120			64 x 40
skhrnb02	==	skhrnb01+(64*40*2)	;  4608			64 x 36
skhrnb03	==	skhrnb02+(64*36*2)	;  5248			64 x 41
skhrnb04	==	skhrnb03+(64*41*2)	;  4352			64 x 34
skhrnb05	==	skhrnb04+(64*34*2)	;  3200			64 x 25
skhrnb06	==	skhrnb05+(64*25*2)	;  4608			64 x 36
skhrnb07	==	skhrnb06+(64*36*2)	;  5120			64 x 40
skhrnb08	==	skhrnb07+(64*40*2)	;  4736			64 x 37
							; 42624	202720
skhrnf00	==	skhrnb08+(64*37*2)	;  2496			32 x 39
skhrnf04	==	skhrnf00+(32*39*2)	;  2880			32 x 30
skhrnf05	==	skhrnf04+(32*30*2)	;  3200			32 x 24
skhrnf06	==	skhrnf05+(32*24*2)	;  3456			32 x 32
skhrnf07	==	skhrnf06+(32*32*2)	;  2560			32 x 45
skhrnf08	==	skhrnf07+(32*45*2)	;  2880			32 x 50
skhrnf01	==	skhrnf08+(32*50*2)	;  1920			64 x 27
skhrnf02	==	skhrnf01+(64*27*2)	;  1536			64 x 20
skhrnf03	==	skhrnf02+(64*20*2)	;  2048			48 x 30
							; 22976	225696
skhrnn00	==	skhrnf03+(48*30*2)	;  1344			32 x 21
skhrnn01	==	skhrnn00+(32*21*2)	;  1088			32 x 17
skhrnn02	==	skhrnn01+(32*17*2)	;   832			32 x 13
skhrnn03	==	skhrnn02+(32*13*2)	;  1152			32 x 18
skhrnn04	==	skhrnn03+(32*18*2)	;  1408			32 x 22
skhrnn05	==	skhrnn04+(32*22*2)	;  1536			32 x 24
							;  7360	233056
skullsh0	==	skhrnn05+(32*24*2)	;   512	233568	32 x 8


citybs00	==	lev_data			; 44544			128 x 174
;2 line pad
cityhd00	==	citybs00+44544		;  3840			48 x 40
cityhd01	==	cityhd00+3840		;  3840
cityhd02	==	cityhd01+3840		;  3840
cityhd03	==	cityhd02+3840		;  3840
cityhd04	==	cityhd03+3840		;  3840
cityhd05	==	cityhd04+3840		;  3840
cityhd06	==	cityhd05+3840		;  3840
citysh00	==	cityhd06+3840		;   640			32 x 10		head shot
citysh01	==	citysh00+640		;   640			32 x 10		head shot
citysh02	==	citysh01+640		;   768			32 x 12		shoulder missile
citysh03	==	citysh02+768		;   768			32 x 12		shoulder missile
;4 line pad
citysh04	==	citysh03+768		;  1920			32 x 30		ring
;2 line pad
							; 76160



serp00	==	lev_data			; 28224			224 x 63
serp01	==	serp00+28224		; 28224
serp02	==	serp01+28224		; 28224
serp03	==	serp02+28224		; 28224
serp04	==	serp03+28224		; 28224
serp05	==	serp04+28224		; 28224
serp06	==	serp05+28224		; 28224
serp07	==	serp06+28224		; 28224
serp08	==	serp07+28224		; 28224			;firing
serp09	==	serp08+28224		; 28224
serp10	==	serp09+28224		; 28224
							;310464	310464
serplw00	==	serp10+28224		; 20480			160 x 64
serplw01	==	serplw00+(160*64*2)	; 26880			160 x 84
serplw02	==	serplw01+(160*84*2)	; 27840			160 x 87
serplw03	==	serplw02+(160*87*2)	; 22720			160 x 71
serplw04	==	serplw03+(160*71*2)	; 18880			160 x 59
serplw05	==	serplw04+(160*59*2)	; 15040			160 x 47
;4 line pad
serplw06	==	serplw05+(160*47*2)	; 17280			192 x 45
serplw07	==	serplw06+(192*45*2)	; 19200			192 x 50
serplw08	==	serplw07+(192*50*2)	; 18432			192 x 48
;1 line pad
							;186752	497216
serprw00	==	serplw08+(192*48*2)	; 21440			160 x 67
serprw01	==	serprw00+(160*67*2)	; 25600			160 x 80
serprw02	==	serprw01+(160*80*2)	; 25920			160 x 81
serprw03	==	serprw02+(160*81*2)	; 24000			160 x 75
serprw04	==	serprw03+(160*75*2)	; 24000			160 x 75
serprw05	==	serprw04+(160*75*2)	; 24000			160 x 75
serprw06	==	serprw05+(160*75*2)	; 24000			160 x 75
serprw07	==	serprw06+(160*75*2)	; 23360			160 x 73
serprw08	==	serprw07+(160*73*2)	; 20160			160 x 63
							;212480	709696
serpsht0	==	serprw08+(160*63*2)	;  2304			48 x 24


quetbd00	==	lev_data			; 30720			192 x 80
quetbd01	==	quetbd00+30720		; 30720
quetbd02	==	quetbd01+30720		; 30720
quetbd03	==	quetbd02+30720		; 30720
quetbd04	==	quetbd03+30720		; 30720
quetbd05	==	quetbd04+30720		; 30720
quetbd06	==	quetbd05+30720		; 30720
quetbd07	==	quetbd06+30720		; 30720
quetbd08	==	quetbd07+30720		; 30720
quetbd09	==	quetbd08+30720		; 30720
quetbd10	==	quetbd09+30720		; 30720
quetbd11	==	quetbd10+30720		; 30720
quetbd12	==	quetbd11+30720		; 30720
quetbd13	==	quetbd12+30720		; 30720
quetbd14	==	quetbd13+30720		; 30720
quetbd15	==	quetbd14+30720		; 30720
							;491520	491520
quetab00	==	quetbd15+30720		;  2880			80 x 18
quetab01	==	quetab00+2880		;  2880
quetab02	==	quetab01+2880		;  2880
quetab03	==	quetab02+2880		;  2880
quetab04	==	quetab03+2880		;  2880
quetab05	==	quetab04+2880		;  2880
quetab06	==	quetab05+2880		;  2880
quetab07	==	quetab06+2880		;  2880
quetab08	==	quetab07+2880		;  2880
quetab09	==	quetab08+2880		;  2880
quetab10	==	quetab09+2880		;  2880
quetab11	==	quetab10+2880		;  2880
quetab12	==	quetab11+2880		;  2880
quetab13	==	quetab12+2880		;  2880
quetab14	==	quetab13+2880		;  2880
quetab15	==	quetab14+2880		;  2880
							; 46080	537600
quetaf00	==	tile00			;  3040			80 x 19		;start at tile00 so it won't write over the foreground objects
quetaf01	==	quetaf00+3040		;  3040
quetaf02	==	quetaf01+3040		;  3040
quetaf03	==	quetaf02+3040		;  3040
quetaf04	==	quetaf03+3040		;  3040
quetaf05	==	quetaf04+3040		;  3040
quetaf06	==	quetaf05+3040		;  3040
quetaf07	==	quetaf06+3040		;  3040
quetaf08	==	quetaf07+3040		;  3040
quetaf09	==	quetaf08+3040		;  3040
quetaf10	==	quetaf09+3040		;  3040
quetaf11	==	quetaf10+3040		;  3040
quetaf12	==	quetaf11+3040		;  3040
quetaf13	==	quetaf12+3040		;  3040
quetaf14	==	quetaf13+3040		;  3040			this one is 80 x 20, but top line of next frame is blank so use it
quetaf15	==	quetaf14+3040		;  3040
							; 46080	 46080
quettl00	==	quetaf15+3040		; 17472			96 x 91
quettl01	==	quettl00+(96*91*2)	; 14592			96 x 76
quettl02	==	quettl01+(96*76*2)	; 11904			96 x 62
quettl03	==	quettl02+(96*62*2)	;  9600			96 x 50
quettl04	==	quettl03+(96*50*2)	;  7296			96 x 38
quettl05	==	quettl04+(96*38*2)	;  4992			96 x 26
quettl06	==	quettl05+(96*26*2)	;  3840			96 x 20
quettl07	==	quettl06+(96*20*2)	;  4992			96 x 26
quettl08	==	quettl07+(96*26*2)	;  7296			96 x 38
quettl09	==	quettl08+(96*38*2)	;  9600			96 x 50
quettl10	==	quettl09+(96*50*2)	; 11904			96 x 62
quettl11	==	quettl10+(96*62*2)	; 14208			96 x 74
quettl12	==	quettl11+(96*74*2)	; 17472			96 x 91
quettl13	==	quettl12+(96*91*2)	; 17472			96 x 91
quettl14	==	quettl13+(96*91*2)	; 17472			96 x 91
quettl15	==	quettl14+(96*91*2)	; 17280			96 x 90
							;187392	233472
quetsht0	==	quettl15+(96*90*2)	;  1536			48 x 16


mud00	==	lev_data			; 32320			80 x 202
;6 line pad
mud01	==	mud00+32320		; 39168			96 x 204
;4 line pad
mud02	==	mud01+39168		; 64960			160x 203
mud03	==	mud02+64960		; 66240			160x 207
;6 line pad
mud04	==	mud03+66240		; 52224			128x 204
mud07	==	mud04+52224		; 52480			128x 205
;7 line pad
mud05	==	mud07+52480		; 90048			224x 201
;7 line pad
mud06	==	mud05+90048		; 79488			192x 207
;1 line pad
							;476928	476928
mudshot	==	mud06+79488		;  2048	478976	32 x 32



oddcld00	==	tile21+36864		; 38752			112 x 173
oddcld01	==	oddcld00+38752		; 38752
oddcld02	==	oddcld01+38752		; 38752
oddcld03	==	oddcld02+38752		; 38752
;4 line pad
							;155008	155008
oddit00	==	fishtx00			; 44800			112 x 200
oddit01	==	oddit00+44800		; 44800
oddit02	==	oddit01+44800		; 44800
oddit03	==	oddit02+44800		; 44800
oddit04	==	oddit03+44800		; 44800
oddit05	==	oddit04+44800		; 44800
oddit06	==	oddit05+44800		; 44800
oddit07	==	oddit06+44800		; 44800
oddit08	==	oddit07+44800		; 44800
oddit09	==	oddit08+44800		; 44800
oddit10	==	oddit09+44800		; 44800
oddit11	==	oddit10+44800		; 44800
							;537600	692608
odditsh0	==	oddit11+44800		;   896	693504	32 x 14
;--------------------------------------------------------------------------



